<%@ Page Language="C#" %>

<script runat="server">

    protected void Button1_Click(object sender, EventArgs e)
    {
        PopulateFields(TextBox1.Text);
    }

    private void PopulateFields(string InputName)
    {
        if(InputName == null)
        {
            Label1.Text = "Cze. Jak si nazywasz?";
        }
        else
        {
            Label1.Text = "Witaj, " + InputName;
        }
        
        if (ScriptManager1.IsInAsyncPostBack && !ScriptManager1.IsNavigating)
        {
            ScriptManager1.AddHistoryPoint("myIndexPoint", InputName, 
              string.Format("Wpisywanie nazwiska: {0}", InputName));
        }
        else
        {
            TextBox1.Text = InputName;
            Page.Title = string.Format("Wpisywanie nazwiska: {0}", InputName);
        }
    }

    protected void ScriptManager1_Navigate(object sender, HistoryEventArgs e)
    {
        PopulateFields(e.State["myIndexPoint"]);
    }

</script>

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title>Strona AJAX-owa</title>
</head>
<body>
    <form id="form1" runat="server">
    <div>
        <asp:ScriptManager ID="ScriptManager1" runat="server" EnableHistory="True" 
         OnNavigate="ScriptManager1_Navigate">
        </asp:ScriptManager>
        <asp:UpdatePanel ID="UpdatePanel1" runat="server">
            <ContentTemplate>
                <asp:Label ID="Label1" runat="server" 
                 Text="Cze. Jak si nazywasz?"></asp:Label><br />
                <br />
                <asp:TextBox ID="TextBox1" runat="server"></asp:TextBox><br />
                <asp:Button ID="Button1" runat="server" Text="Podaj nazwisko" 
                 OnClick="Button1_Click" />
            </ContentTemplate>
        </asp:UpdatePanel>
    </div>
    </form>
</body>
</html>
